# FRET proof: Formal Requirements Elicitation Tool proof

Structured natural languages provide a trade space between ambiguous natural languages that make up most written
requirements, and mathematical formal specifications such as Linear Temporal Logic. FRETish is a structured natural language for the elicitation of system requirements developed at NASA. The related open-source tool Fret provides support for translating FRETish requirements into temporal logic formulas that can be input to several verification and analysis tools. In the context of safety-critical systems, it is crucial to ensure that a generated formula captures the semantics of the corresponding FRETish requirement precisely.
This folder conatins a rigorous formalization of the FRETish language including a denotational semantics and a proof of semantic equivalence between FRETish specifications and their temporal logic counterparts computed by Fret. 

This formalization is presented in:

* Esther Conrad, Laura Titolo, Dimitra Giannakopoulou, Thomas Pressburger, and Aaron Dutle, [A Compositional Proof Framework for FRETish Requirements](https://shemesh.larc.nasa.gov/fm/papers/CPP2022-CTGPD-draft.pdf), Proceedings of the 11th ACM SIGPLAN International Conference on Certified Programs and Proofs (CPP 2022), 2022.

## Requirements
* PVS 8.0 (commit [879b7e9](https://github.com/SRI-CSL/PVS/commit/9a4b9f6f2c4d78855df242aba7d910bb4fe9b1b3) or newer)
* NASAlib (commit [d8025ba](https://github.com/nasa/pvslib/commit/06d898fa4f488c39aba058994e3c875e3ecba854) or newer)
* (Optional, but recommended) VSCode-PVS (commit [a7b6962](https://github.com/nasa/vscode-pvs/commit/a7b6962357f485384434c5681f7863340cf35a17) or newer)

## Contents
The formalization follows the directory structure shown below.

```
.
├── Fretish_MTL
├── FretishAnimated
├── MTL_NuSMV
├── README.md
└── all-libraries
```

The folder `FretishAnimated` contains the definition of Fretish and its semantics; the folder `MTL_NuSMV` contains the semantics of the Metric Temporal Logic as [defined for the NuSMV Model Checker](https://nusmv.fbk.eu/userman/v27/nusmv.pdf); and the folder `Fretish_MTL` contains the formalization of the algorithm translating Fretish to MTL and the lemmas and theorems ensuring its correctness.
The main theorem is `fret_afteruntil_pmltl_equivalence` and it is located in the `FretishToPastMLTL.pvs` file in the `Fretish_MTL` folder.

## Proof Summary

|Library<br>_3_ | Status<br>3&nbsp;✅&nbsp;OK<br>0&nbsp;⚠&nbsp;MISS<br/>0&nbsp;❌&nbsp;FAIL | Attempted Formulas<br>_393_ | Broken Formulas<br>_0_ | Reported&nbsp;Error |
|--- | --- | --- | --- | --- |
|[MTL_NuSMV](summaries/MTL_NuSMV.summary)|✅ OK|174|0||
|[FretishAnimated](summaries/FretishAnimated.summary)|✅ OK|90|0||
|[Fretish_MTL](summaries/Fretish_MTL.summary)|✅ OK|129|0||

## Setting the Library Path

To check the formalization in PVS, the path to NASAlib and the path to this folder must be included as library paths. 
To do this, determine the locations of the NASAlib and Fret_proof folder (using "pwd" in the terminal, for example).
In the terminal, issue the command: 

`export PVS_LIBRARY_PATH="<path_to_nasalib>":"<path_to_Fret_proof>"`

Note that this sets the path for the current terminal session. 
If the terminal is closed, this step needs to be repeated. 

## Proving from the terminal
The shell command `provethem` (included in the PVS installation) can be used to run all proofs in the formalization from the terminal. After setting the library path as described above, navigate to this folder and issue the command `provethem`. 

The output generated should indicate that each of the `Fretish_MTL`, `FretishAnimated`, and `MTL_NuSMV` folders have been successfully proved. 

More detailed output can be found in the output file `all-libraries.grandtotals`, and detailed information in the `summaries` folder. 

## Contact

Esther Conrad <esther.d.conrad@nasa.gov>